/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.analysis.dpCommon;

import ibm.nways.analysis.dpCommon.DataPoint;
import ibm.nways.analysis.dpCommon.PerformanceEvent;
import ibm.nways.analysis.dpCommon.PollingObjectInstance;
import ibm.nways.analysis.dpCommon.ResourceInstance;
import ibm.nways.analysis.dpManager.DpResourceManagerClass;
import ibm.nways.analysis.dpManager.dpServerImpl;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class EventFilter
implements Serializable {
    public static final int AND = 1;
    public static final int AND1 = 2;
    public static final int OR = 4;
    private int logic = 4;
    private int causeMask;
    private String name;
    private String hostname;
    private long begin = -1L;
    private long end = -1L;
    private String tableIndex;
    private PollingObjectInstance thePOI;
    private DpResourceManagerClass theResource;

    public EventFilter(Integer n, String string, String string2, long l, long l2) {
        if (n != null) {
            this.causeMask = n;
        }
        this.name = string;
        this.hostname = string2;
        this.begin = l;
        this.end = l2;
    }

    public EventFilter(Integer n, String string, String string2) {
        if (n != null) {
            this.causeMask = n;
        }
        this.name = string;
        this.hostname = string2;
    }

    public EventFilter(Integer n, String string, String string2, int n2) {
        if (n != null) {
            this.causeMask = n;
        }
        this.name = string;
        this.hostname = string2;
        this.logic = n2;
    }

    public EventFilter(Integer n, PollingObjectInstance pollingObjectInstance, long l, int n2) {
        this.logic = n2;
        this.begin = l;
        if (n != null) {
            this.causeMask = n;
        }
        this.convertToIPAddress(pollingObjectInstance);
        this.thePOI = pollingObjectInstance;
    }

    private void convertToIPAddress(PollingObjectInstance pollingObjectInstance) {
        String string = null;
        try {
            string = InetAddress.getByName(pollingObjectInstance.getHostname()).getHostAddress();
        }
        catch (UnknownHostException unknownHostException) {
            unknownHostException.printStackTrace();
            string = pollingObjectInstance.getHostname();
        }
        pollingObjectInstance.setHostname(string);
    }

    public EventFilter(Integer n, DpResourceManagerClass dpResourceManagerClass, long l, int n2) {
        this.logic = n2;
        this.begin = l;
        if (n != null) {
            this.causeMask = n;
        }
        this.theResource = dpResourceManagerClass;
    }

    public EventFilter(Integer n, PollingObjectInstance pollingObjectInstance, long l, String string, int n2) {
        this.logic = n2;
        this.begin = l;
        this.tableIndex = string;
        if (n != null) {
            this.causeMask = n;
        }
        this.convertToIPAddress(pollingObjectInstance);
        this.thePOI = pollingObjectInstance;
    }

    public EventFilter(Integer n, PollingObjectInstance pollingObjectInstance, long l, long l2, String string, int n2) {
        this.logic = n2;
        this.begin = l;
        this.end = l2;
        this.tableIndex = string;
        if (n != null) {
            this.causeMask = n;
        }
        this.convertToIPAddress(pollingObjectInstance);
        this.thePOI = pollingObjectInstance;
    }

    public int getCauseMask() {
        return this.causeMask;
    }

    public long getBeginTime() {
        return this.begin;
    }

    public long getEndTime() {
        return this.end;
    }

    public boolean filter(PerformanceEvent performanceEvent) {
        return this.filter(performanceEvent, null);
    }

    public boolean filter(PerformanceEvent performanceEvent, dpServerImpl dpServerImpl2) {
        boolean bl = false;
        if (this.logic == 1) {
            if (this.filterCauseMask(performanceEvent) && (this.filterPOI(performanceEvent) || this.filterResource(performanceEvent, dpServerImpl2)) && this.filterTime(performanceEvent)) {
                bl = true;
            }
        } else if (this.logic == 2) {
            if (this.filterCauseMask(performanceEvent) && this.filterHostname(performanceEvent) && this.filterName(performanceEvent)) {
                bl = true;
            }
        } else if (this.logic == 4 && (this.filterCauseMask(performanceEvent) || this.filterPOI(performanceEvent) || this.filterResource(performanceEvent, dpServerImpl2) || this.filterName(performanceEvent) || this.filterHostname(performanceEvent) || this.filterTime(performanceEvent) || this.filterStartTime(performanceEvent))) {
            bl = true;
        }
        return bl;
    }

    private boolean filterCauseMask(PerformanceEvent performanceEvent) {
        boolean bl = false;
        if (this.causeMask != 0 && (performanceEvent.getCause() & this.causeMask) != 0) {
            bl = true;
        }
        return bl;
    }

    private boolean filterPOI(PerformanceEvent performanceEvent) {
        boolean bl = false;
        if (this.thePOI != null && performanceEvent != null && performanceEvent.equalsPollingObjectInstance(this.thePOI)) {
            bl = this.filterIndex(performanceEvent);
        }
        return bl;
    }

    private boolean filterResource(PerformanceEvent performanceEvent, dpServerImpl dpServerImpl2) {
        boolean bl = false;
        if (dpServerImpl2 != null && this.theResource != null) {
            ResourceInstance resourceInstance = null;
            try {
                resourceInstance = dpServerImpl2.getResourceInstance(this.theResource);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            if (resourceInstance != null) {
                if (resourceInstance.getHostname().equals(performanceEvent.getHostname()) && resourceInstance.getDefinition().getDefinitionVector().indexOf(performanceEvent.getIdentifier()) != -1) {
                    bl = true;
                }
            } else {
                System.out.println("Resource Instance was null");
            }
        }
        return bl;
    }

    private boolean filterIndex(PerformanceEvent performanceEvent) {
        boolean bl = false;
        if (this.tableIndex == null) {
            if (((DataPoint)performanceEvent.getHistory().firstElement()).getID() == null) {
                bl = true;
            }
        } else if (performanceEvent.getHistory() != null && performanceEvent.getHistory().firstElement() != null && ((DataPoint)performanceEvent.getHistory().firstElement()).getID() != null && ((DataPoint)performanceEvent.getHistory().firstElement()).getID().equals(this.tableIndex)) {
            bl = true;
        }
        return bl;
    }

    private boolean filterName(PerformanceEvent performanceEvent) {
        boolean bl = false;
        if (this.name != null && this.name.equals(performanceEvent.getEventName())) {
            bl = true;
        }
        return bl;
    }

    private boolean filterHostname(PerformanceEvent performanceEvent) {
        boolean bl = false;
        if (this.hostname != null && this.hostname.equals(performanceEvent.getHostname())) {
            bl = true;
        }
        return bl;
    }

    private boolean filterTime(PerformanceEvent performanceEvent) {
        boolean bl = false;
        if (this.end < 0L) {
            if (this.begin < 0L || performanceEvent.getEventTime() >= this.begin) {
                bl = true;
            }
        } else if (this.begin > -1L && performanceEvent.getEventTime() >= this.begin && performanceEvent.getEventTime() <= this.end) {
            bl = true;
        }
        return bl;
    }

    private boolean filterStartTime(PerformanceEvent performanceEvent) {
        boolean bl = false;
        if (this.begin > -1L && performanceEvent.getEventTime() >= this.begin) {
            bl = true;
        }
        return bl;
    }

    public String getEventName() {
        if (this.thePOI != null) {
            return this.thePOI.getIdentifier();
        }
        return this.name;
    }

    public String getHostname() {
        if (this.thePOI != null) {
            return this.thePOI.getHostname();
        }
        return this.hostname;
    }

    public long getPOIIndex() {
        long l = -1L;
        if (this.thePOI != null) {
            l = this.thePOI.getIndex();
        }
        return l;
    }

    public String getIndexString() {
        return this.tableIndex;
    }

    public void setIndexString(String string) {
        this.tableIndex = string;
    }

    public DpResourceManagerClass getResourceManager() {
        return this.theResource;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("Event Filter: \n");
        if (this.logic == 4) {
            stringBuffer.append("Logic is OR");
        } else if (this.logic == 1) {
            stringBuffer.append("Logic is AND");
        } else if (this.logic == 2) {
            stringBuffer.append("Logic is AND1");
        }
        stringBuffer.append("\nCause mask is: " + this.causeMask);
        stringBuffer.append("\nBegin Time is: " + this.begin);
        stringBuffer.append("\nEnd Time is: " + this.end);
        stringBuffer.append("\n");
        if (this.thePOI != null) {
            stringBuffer.append(this.thePOI.toString());
        }
        if (this.theResource != null) {
            stringBuffer.append(this.theResource.toString());
        }
        return stringBuffer.toString();
    }
}

